---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：30-TermVectors API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **TermVectorsServiceの詳細ロジック**：TermVectorsService.javaの内部処理未精査
  2. **REST APIエンドポイントパス**：RESTハンドラーのコード未参照

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/termvectors/TransportTermVectorsAction.java` - 実行ロジック
- E-02: `server/src/main/java/org/opensearch/action/termvectors/TermVectorsRequest.java` - リクエスト構造（先頭100行）
- E-03: `server/src/main/java/org/opensearch/action/termvectors/` - ディレクトリ構造
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportSingleShardAction継承 | E-01 (62行目) | ○ |
| C-02 | GETスレッドプールで実行 | E-01 (83行目) | ○ |
| C-03 | doc指定時のランダムシャード選択 | E-01 (100-104行目) | ○ |
| C-04 | IDベースルーティング | E-01 (107-108行目) | ○ |
| C-05 | セグメントレプリケーション対応のプライマリ優先 | E-01 (92-98行目) | ○ |
| C-06 | ルーティング解決と必須チェック | E-01 (117-124行目) | ○ |
| C-07 | realtime判定とawaitShardSearchActive | E-01 (131-141行目) | ○ |
| C-08 | TermVectorsService.getTermVectors()呼び出し | E-01 (148行目) | ○ |
| C-09 | SEARCH_THROTTLEDスレッドプール対応 | E-01 (157-162行目) | ○ |
| C-10 | RealtimeRequestインターフェース | E-02 (81行目) | ○ |
| C-11 | PublicApi(since = "1.0.0") | E-02 (80行目) | ○ |
| C-12 | OFFSETS, POSITIONS, PAYLOADS, DFS等のフィールド | E-02 (88-92行目) | ○ |
| C-13 | MultiTermVectorsAction存在 | E-03 | ○ |
| C-14 | TermVectorsServiceの内部ターム抽出ロジック | **根拠なし** | △ |
| C-15 | REST APIエンドポイントパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TermVectorsService詳細：Luceneからのターム情報抽出ロジックの詳細
  - 候補：TermVectorsService.java
- REST APIエンドポイント：RESTハンドラーの詳細コードを参照していない
  - 候補：RestTermVectorsAction.java / RestMultiTermVectorsAction.java

## 5) リスクフラグ（レビュー観点）
- 1: TermVectorsServiceの内部処理の正確性
- 0: REST APIパスの正確性

## 6) レビュアーチェックリスト（最小）
- [ ] TermVectorsService.getTermVectors()の内部処理を確認
- [ ] REST APIエンドポイントパスの正確性を確認
- [ ] 仮想ドキュメント（doc）のターム分析動作を確認
